<?php
/*--------------------------------------------------------------
   Widget.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Options;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Height;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\HorizontalPosition;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Icon;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Id;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Label;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\VerticalPosition;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Visualization;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Width;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

class Widget
{
    /**
     * @var Id
     */
    private $id;
    
    /**
     * @var Data
     */
    private $data;
    
    /**
     * @var Options
     */
    private $options;
    
    /**
     * @var Label
     */
    private $label;
    
    /**
     * @var Visualization
     */
    private $visualization;
    
    /**
     * @var Width
     */
    private $width;
    
    /**
     * @var Height
     */
    private $height;
    
    /**
     * @var HorizontalPosition
     */
    private $horizontalPosition;
    
    /**
     * @var VerticalPosition
     */
    private $verticalPosition;
    
    /**
     * @var Icon
     */
    private $icon;
    
    
    /**
     * Constructor.
     */
    private function __construct(
        Id $id,
        Label $label,
        Icon $icon,
        Width $width,
        Height $height,
        HorizontalPosition $horizontalPosition,
        VerticalPosition $verticalPosition,
        Visualization $visualization,
        Options $options,
        Data $data
    ) {
        $this->id                 = $id;
        $this->label              = $label;
        $this->icon               = $icon;
        $this->width              = $width;
        $this->height             = $height;
        $this->horizontalPosition = $horizontalPosition;
        $this->verticalPosition   = $verticalPosition;
        $this->visualization      = $visualization;
        $this->options            = $options;
        $this->data               = $data;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(
        Id $id,
        Label $label,
        Icon $icon,
        Width $width,
        Height $height,
        HorizontalPosition $horizontalPosition,
        VerticalPosition $verticalPosition,
        Visualization $visualization,
        Options $options,
        Data $data
    ): self {
        return new self($id,
                        $label,
                        $icon,
                        $width,
                        $height,
                        $horizontalPosition,
                        $verticalPosition,
                        $visualization,
                        $options,
                        $data);
    }
    
    
    /**
     * Return ID.
     */
    public function id(): Id
    {
        return $this->id;
    }
    
    
    /**
     * Return data.
     */
    public function data(): Data
    {
        return $this->data;
    }
    
    
    /**
     * Return options.
     */
    public function options(): Options
    {
        return $this->options;
    }
    
    
    /**
     * Return label.
     */
    public function label(): Label
    {
        return $this->label;
    }
    
    
    /**
     * Return width.
     */
    public function width(): Width
    {
        return $this->width;
    }
    
    
    /**
     * Return height.
     */
    public function height(): Height
    {
        return $this->height;
    }
    
    
    /**
     * Return horizontal position.
     */
    public function horizontalPosition(): HorizontalPosition
    {
        return $this->horizontalPosition;
    }
    
    
    /**
     * Return vertical position.
     */
    public function verticalPosition(): VerticalPosition
    {
        return $this->verticalPosition;
    }
    
    
    /**
     * Return icon.
     */
    public function icon(): Icon
    {
        return $this->icon;
    }
    
    
    /**
     * Return visualization.
     */
    public function visualization(): Visualization
    {
        return $this->visualization;
    }
}